package GraphicThreads;

import javafx.application.Platform;

import java.io.Serializable;
import java.util.ArrayList;
import UI.MyPane;
import Back.Node;
import Back.Tree;



public abstract class GraphicThread<T extends Serializable & Comparable<T> > extends Thread {
    Tree<T> tree;
    int SLEEP_TIME;
    MyPane pane;

    /**
     * @return vrati tree
     */
    public Tree<T> getTree(){
        return tree;
    }


    /**
     * @param t nastavi tree na t
     */
    public void setTree( Tree<T> t){
         tree = t;
    }

    /**
     * @return vrati pane na ktorom thread pracuje
     */
    public MyPane getPane(){
        return pane;
    }

    /**
     * @param p nastavi pane na p
     */
    public void setPane( MyPane p){
        pane = p;
    }

    /**
     * nastavi sleep time na 0 cim vlastne thread nebude spat
     */
    public void skip(){
        SLEEP_TIME = 0;
    }

    /**
     * funkcia ktora upravi SLEEP_TIME podla parametra pridaj
     * ak je  true, prida 500
     * ak je false, odcita 500
     * kontroluje tieto hodnoty ci nie su v hraniciach ak ano neurobi nic
     * @param pridaj
     */
    public void setSleepTime(boolean pridaj){
        if ( pridaj ){
            if ( SLEEP_TIME < 2000 ){
                SLEEP_TIME += 250;
            }
        } else {
            if ( SLEEP_TIME > 500 ){
                SLEEP_TIME -= 250;
            }
        }
    }

    /**
     * konstruktor, pradi pane
     * pane prideli nove aktualizovane tree
     * nasledne ho na hlavno threade aktualizuje
     * zaspi na SLEEP_TIME
     */
    void updateTree()  {
        Platform.runLater(() -> {
            pane.update();
        });

        //System.out.println(SLEEP_TIME ) ;
        try {
            sleep(SLEEP_TIME);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /**
     * prerobena funkcia Node.FindByNode
     * hlada ci sa find nachadza v podstrome node
     * ak ho najde vrati ho, ak nie vracia null
     * popri tom zakazdym aktualnym vrcholom prideli find true
     * akoze je v nich find, updatne pane
     * pred vratenim null nastavi find na false
     * @param find vrchol ktory sa hlada
     * @param node vrchol v ktorom sa hlada
     * @return ak najde find v podstrome node vrati ho, inac vrati false
     */
     Node<T> threadFindByNode(Node<T> node, Node<T> find){
        if ( node == null ) return null;
        //System.out.println("find : " + node + " " + find  + SLEEP_TIME + " " );
        node.setFind(true);
        updateTree();

        if ( node.equals(find) ) return node;

        if ( node.getSons() != null ){
            for ( Node<T> son : node.getSons()){
                Node<T> s = threadFindByNode(son, find);

                if ( s != null ) return s;
            }
        }

        node.setFind(false);
        return null;
     }


    /**
     * prerobena funkcia Node.add <----- vylepsena, neprechadza Node ktore boli spracovane uz raz add
     * aktualym prvkom nastavuje add na true
     * postupne prejde potomkov, zisti ci maju nieco naviac
     * ak ano, prida
     * @param where vrchol ktory sa hlada
     * @param node vrchol v ktorom sa hlada
     */
    void threadAdd(Node<T> where, Node<T> node){
        //System.out.println("Add : " + where + " " + node  + SLEEP_TIME);

        if ( node != null ) {
            node.setAdd(true);
            where.setAdd(true);
            updateTree();

            int i = 0;

            for (var n_son : node.getSons()) {
                if (where.getSons().contains(n_son)) {
                    for ( Node w_son : where.getSons()){
                        if ( !w_son.getAdd() ) { // <------------
                            w_son.setFind(true);
                            updateTree();
                            if (w_son.equals(n_son)) {
                                threadAdd(w_son, n_son);
                                w_son.setFind(false);
                                updateTree();
                                break;
                            }
                            w_son.setFind(false);
                            updateTree();
                        }
                    }
                } else {
                    n_son.setAdd(true);
                    where.insertNode(i, n_son);
                    //nove.add(n_son);
                }
                i++;
            }

        }
    }


    private void threadRemoveNode(Node<T> node, Node<T> remove ){
        remove.setAdd(true);
        updateTree();

        node.removeNode(remove);
        updateTree();
    }

    /**
     * graficky odstrani vrchol zo synov
     * pokusi sa najst otca, ak je null
     * skusi ci nema odstranit vrchol
     * ak najde odstrani find zo synov
     * @param node koren stromu z ktoreho sa odstranuje
     * @param find vrchol ktory sa odstranuje
     */
    public boolean threadRemove(Node<T> node, Node<T> find ){
        Node<T> father = threadFindFatherByNode(node, find);

        if ( father == null ) {
            if ( node.equals(find)){ // ROOT
                node.setFind(true);
                updateTree();

                node.setValue(null);
                node.setSons(null);
                updateTree();
                return true;
            }
        }

        for ( Node<T> son : father.getSons() ){
            if ( son.equals(find)){
                threadRemoveNode(father, son);
                return true;
            }
        }

        return false;
    }

    /**
     * graficky prerobena funkcia Node.FindFatherByNode()
     * @param node koren stromu v ktorom sa hlada
     * @param find vrchol ktoremu sa hlada otec
     */
    public Node<T> threadFindFatherByNode(Node<T> node, Node<T> find ) {
        if (find == null) return null;

        node.setFind(true);
        updateTree();

        if (node.equals(find)) {
            node.setFind(false);
            updateTree();
            return null;
        }

        if (node.getSons() == null) {
            node.setFind(false);
            updateTree();
            return null;
        }

        if (node.getSons().contains(find)) { return node; }

        if (node.getSons() != null) {
                for (Node<T> son : node.getSons()) {
                    Node<T> s = threadFindFatherByNode(son, find);
                    if (s != null) return s;
                }
            }

        node.setFind(false);
        updateTree();
        return null;
        }


    /**
     * abstraktna metoda ktoru musi mat kazdy potomok tejto triedy
     */
    public abstract void run();

}
